class MH2_Pickup_Health extends TournamentHealth;

#exec mesh import mesh=MH2_Health anivfile=Models\MH2_Health_a.3d datafile=Models\MH2_Health_d.3d x=0 y=0 z=0 mlod=0
#exec mesh origin mesh=MH2_Health x=0 y=0 z=0
#exec mesh sequence mesh=MH2_Health seq=All startframe=0 numframes=1

#exec meshmap new meshmap=MH2_Health mesh=MH2_Health
#exec meshmap scale meshmap=MH2_Health x=0.06250 y=0.06250 z=0.12500

var() int HealingAmount;

event float BotDesireability(Pawn Bot)
{
return ( 0 ); 
}

function PlayPickupMessage(Pawn Other)
{
	Other.ReceiveLocalizedMessage( class'PickupMessagePlus', 0, None, None, Self.Class );
}

auto state Pickup
{	
	function Touch( actor Other)
		{
		local int HealMax;
		local PlayerPawn P;
			
		if ( ValidTouch(Other)  && Other.IsA('PlayerPawn')) 
			{	
			P = PlayerPawn(Other);	
			HealMax = Info_PRI(P.PlayerReplicationInfo).HealthMax;

			if (P.Health < HealMax) 
				{
				if (Level.Game.LocalLog != None)
					Level.Game.LocalLog.LogPickup(Self, P);
				if (Level.Game.WorldLog != None)
					Level.Game.WorldLog.LogPickup(Self, P);
				P.Health += HealingAmount;
				if (P.Health > HealMax) P.Health = HealMax;
				PlayPickupMessage(P);
				PlaySound (PickupSound,,2.5);
				Other.MakeNoise(0.2);		
				SetRespawn();
				}
			}
		}
}

defaultproperties
{
     DrawScale=0.2
     HealingAmount=5
     PickupMessage="You picked up 5 Health points."
     ItemName="MH2 Health"
     RespawnTime=30.000000
     PickupViewMesh=Mesh'MH2_Health'
     PickupSound=Sound'Botpack.Pickups.UTHealth'
     Mesh=Mesh'MH2_Health'
     ScaleGlow=2.000000
     CollisionRadius=16.000000
     CollisionHeight=16.000000
     MultiSkins(0)=Texture'eol.epanel4'
     MultiSkins(1)=Texture'eol.espot'
     MultiSkins(2)=Texture'UnrealShare.Belt_fx.UDamageFX'
}
